<?php
/*
Plugin Name: Agenda
Description: Plugin de agendamento de sessões com gestão de horários.
Version: 1.0
Author: Seu Nome
*/

if (!defined('ABSPATH')) {
    exit; // Evita acesso direto
}

// Inclui os arquivos necessários
include_once plugin_dir_path(__FILE__) . 'includes/database.php';
include_once plugin_dir_path(__FILE__) . 'includes/agendar-sessao.php';
include_once plugin_dir_path(__FILE__) . 'includes/pacientes.php';  // Inclui o arquivo de pacientes




// Função de ativação do plugin
function ativar_agenda() {
    criar_tabelas_agenda();
}
register_activation_hook(__FILE__, 'ativar_agenda');

// Adiciona os submenus para a Agenda
function adicionar_menu_agenda() {
    add_menu_page(
        'Agenda',
        'Agenda',
        'manage_options',
        'agenda',
        'render_agendar_sessao'
    );

    add_submenu_page(
        'agenda',
        'Agendar Sessão',
        'Agendar Sessão',
        'manage_options',
        'agendar-sessao',
        'render_agendar_sessao'
    );

    add_submenu_page(
        'agenda',
        'Lista de Sessões',
        'Lista de Sessões',
        'manage_options',
        'lista-sessoes',
        'render_lista_sessoes'
    );

    
    add_submenu_page('agenda', 'Lista de Pacientes', 'Lista de Pacientes', 'manage_options', 'lista-pacientes', 'render_lista_pacientes');
    add_submenu_page(null, 'Editar Paciente', 'Editar Paciente', 'manage_options', 'editar-paciente', 'render_editar_paciente'); // Página oculta para edição


   
}
add_action('admin_menu', 'adicionar_menu_agenda');

function adicionar_menu_dias_folga() {
    add_submenu_page(
        'agenda',               // Slug do menu principal
        'Dias de Folga',        // Título da página
        'Dias de Folga',        // Nome do submenu
        'manage_options',       // Permissão necessária
        'dias-de-folga',        // Slug do submenu
        'render_dias_de_folga'  // Callback do submenu
    );
}
add_action('admin_menu', 'adicionar_menu_dias_folga');

// Função para renderizar a página de Dias de Folga
function render_dias_de_folga() {
    include plugin_dir_path(__FILE__) . 'templates/dias-de-folga.php';
}


// Carrega os estilos do plugin
function carregar_estilos_agenda() {
    wp_enqueue_style('estilo-agenda', plugin_dir_url(__FILE__) . 'assets/css/estilo.css');
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css'); // Adiciona o Font Awesome
}
add_action('admin_enqueue_scripts', 'carregar_estilos_agenda');

function criar_tabela_dias_folga() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();

    $tabela_dias_folga = $wpdb->prefix . 'dias_folga';
    $sql = "CREATE TABLE IF NOT EXISTS $tabela_dias_folga (
        id INT NOT NULL AUTO_INCREMENT,
        data_folga DATE NOT NULL,
        PRIMARY KEY (id),
        UNIQUE (data_folga)  -- Impede duplicações da mesma data
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
register_activation_hook(__FILE__, 'criar_tabela_dias_folga');

function atualizar_tabela_sessoes_agenda() {
    global $wpdb;
    $tabela_sessoes_agenda = $wpdb->prefix . 'sessoes_agenda';

    // Verifica e adiciona a coluna `paciente_id` se não existir
    $coluna_paciente_id = $wpdb->get_results("SHOW COLUMNS FROM $tabela_sessoes_agenda LIKE 'paciente_id'");
    if (empty($coluna_paciente_id)) {
        $wpdb->query("ALTER TABLE $tabela_sessoes_agenda ADD COLUMN paciente_id INT NOT NULL AFTER id");
    }

    // Verifica e adiciona a coluna `nome_paciente` se não existir
    $coluna_nome_paciente = $wpdb->get_results("SHOW COLUMNS FROM $tabela_sessoes_agenda LIKE 'nome_paciente'");
    if (empty($coluna_nome_paciente)) {
        $wpdb->query("ALTER TABLE $tabela_sessoes_agenda ADD COLUMN nome_paciente VARCHAR(255) AFTER paciente_id");
    }

    // Verifica e adiciona a coluna `telefone` se não existir
    $coluna_telefone = $wpdb->get_results("SHOW COLUMNS FROM $tabela_sessoes_agenda LIKE 'telefone'");
    if (empty($coluna_telefone)) {
        $wpdb->query("ALTER TABLE $tabela_sessoes_agenda ADD COLUMN telefone VARCHAR(20) AFTER nome_paciente");
    }
}
register_activation_hook(__FILE__, 'atualizar_tabela_sessoes_agenda');




