<?php

// Renderiza o formulário de agendamento
function render_agendar_sessao() {
    // Exibe mensagens de sucesso ou erro, se houver
    if (isset($_GET['mensagem']) && $_GET['mensagem'] === 'sucesso') {
        echo '<div class="notice notice-success"><p>Sessão agendada com sucesso!</p></div>';
    } elseif (isset($_GET['mensagem']) && $_GET['mensagem'] === 'erro') {
        echo '<div class="notice notice-error"><p>Horário já ocupado. Escolha outro horário.</p></div>';
    }
    
    include plugin_dir_path(__FILE__) . '../templates/agendar-sessao-form.php';
}

// Renderiza a lista de sessões
function render_lista_sessoes() {
    global $wpdb;
    $tabela_sessoes = $wpdb->prefix . 'sessoes_agenda';
    $sessoes = $wpdb->get_results("SELECT * FROM $tabela_sessoes ORDER BY data_sessao, hora_sessao");

    include plugin_dir_path(__FILE__) . '../templates/lista-sessoes.php';
}

// Processa o agendamento
function processar_agendamento() {
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] === 'agendar_sessao') {
        global $wpdb;

        // Captura o ID do paciente e valida se ele foi selecionado
        $paciente_id = intval($_POST['paciente_id']);
        if (empty($paciente_id)) {
            wp_redirect(admin_url('admin.php?page=agendar-sessao&mensagem=erro_paciente_nao_selecionado'));
            exit;
        }

        // Captura e sanitiza os dados da sessão
        $data_sessao = sanitize_text_field($_POST['data_sessao']);
        $hora_sessao = sanitize_text_field($_POST['hora_sessao']);
        $local_sessao = sanitize_text_field($_POST['local_sessao']);
        $metodo_pagamento = sanitize_text_field($_POST['metodo_pagamento']);

        // Verifica se já existe uma sessão para a data e horário selecionados
        $tabela_sessoes = $wpdb->prefix . 'sessoes_agenda';
        $horario_ocupado = $wpdb->get_var($wpdb->prepare(
            "SELECT COUNT(*) FROM $tabela_sessoes WHERE data_sessao = %s AND hora_sessao = %s AND status = 'ativa'",
            $data_sessao, $hora_sessao
        ));

        if ($horario_ocupado > 0) {
            // Redireciona com uma mensagem de erro no caso de horário ocupado
            wp_redirect(admin_url('admin.php?page=agendar-sessao&mensagem=erro_horario_ocupado'));
            exit;
        }

        // Insere o agendamento na tabela de sessões
        $resultado_agendamento = $wpdb->insert(
            $tabela_sessoes,
            [
                'paciente_id' => $paciente_id,
                'data_sessao' => $data_sessao,
                'hora_sessao' => $hora_sessao,
                'local_sessao' => $local_sessao,
                'metodo_pagamento' => $metodo_pagamento,
                'status' => 'ativa'
            ]
        );

        // Verifica o resultado da inserção e redireciona com a mensagem apropriada
        if ($resultado_agendamento === false) {
            wp_redirect(admin_url('admin.php?page=agendar-sessao&mensagem=erro_agendamento'));
        } else {
            wp_redirect(admin_url('admin.php?page=agendar-sessao&mensagem=sucesso'));
        }
        exit;
    }
}
add_action('admin_post_agendar_sessao', 'processar_agendamento');



// Processa o cancelamento da sessão
function cancelar_sessao() {
    if (isset($_GET['acao']) && $_GET['acao'] === 'cancelar' && isset($_GET['sessao_id'])) {
        global $wpdb;
        $tabela_sessoes = $wpdb->prefix . 'sessoes_agenda';
        $sessao_id = intval($_GET['sessao_id']);

        // Atualiza o status da sessão para 'cancelada' sem excluir o registro
        $wpdb->update(
            $tabela_sessoes,
            ['status' => 'cancelada'],
            ['id' => $sessao_id]
        );

        // Redireciona de volta para a lista de sessões com uma mensagem de cancelamento
        wp_redirect(admin_url('admin.php?page=lista-sessoes&mensagem=cancelada'));
        exit;
    }
}
add_action('admin_init', 'cancelar_sessao');

function excluir_sessao_cancelada() {
    if (isset($_GET['sessao_id'])) {
        global $wpdb;
        $tabela_sessoes = $wpdb->prefix . 'sessoes_agenda';
        $sessao_id = intval($_GET['sessao_id']);

        // Exclui a sessão se o status for "cancelada"
        $sessao = $wpdb->get_row($wpdb->prepare("SELECT status FROM $tabela_sessoes WHERE id = %d", $sessao_id));
        if ($sessao && $sessao->status === 'cancelada') {
            $wpdb->delete($tabela_sessoes, ['id' => $sessao_id]);
            wp_redirect(admin_url('admin.php?page=lista-sessoes&mensagem=sessao_excluida'));
        } else {
            wp_redirect(admin_url('admin.php?page=lista-sessoes&mensagem=erro_exclusao'));
        }
        exit;
    }
}
add_action('admin_post_excluir_sessao_cancelada', 'excluir_sessao_cancelada');


