// Função para salvar um novo dia de folga
function salvar_dia_de_folga() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['data_folga'])) {
        global $wpdb;
        $tabela_dias_folga = $wpdb->prefix . 'dias_folga';
        $data_folga = sanitize_text_field($_POST['data_folga']);

        // Insere o novo dia de folga
        $wpdb->insert($tabela_dias_folga, ['data_folga' => $data_folga]);

        wp_redirect(admin_url('admin.php?page=dias-de-folga&mensagem=dia_salvo'));
        exit;
    }
}
add_action('admin_post_salvar_dia_de_folga', 'salvar_dia_de_folga');

// Função para excluir um dia de folga
function excluir_dia_de_folga() {
    if (isset($_GET['dia_id'])) {
        global $wpdb;
        $tabela_dias_folga = $wpdb->prefix . 'dias_folga';
        $dia_id = intval($_GET['dia_id']);

        // Exclui o dia de folga
        $wpdb->delete($tabela_dias_folga, ['id' => $dia_id]);

        wp_redirect(admin_url('admin.php?page=dias-de-folga&mensagem=dia_excluido'));
        exit;
    }
}
add_action('admin_post_excluir_dia_de_folga', 'excluir_dia_de_folga');
