<?php

if (!function_exists('criar_tabelas_agenda')) {
    function criar_tabelas_agenda() {
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();

        // Tabela para armazenar sessões
        $tabela_sessoes = $wpdb->prefix . 'sessoes_agenda';
        $sql_sessoes = "CREATE TABLE $tabela_sessoes (
            id INT NOT NULL AUTO_INCREMENT,
            nome_paciente VARCHAR(100) NOT NULL,
            telefone VARCHAR(20) NOT NULL,
            local_sessao VARCHAR(20) NOT NULL,
            data_sessao DATE NOT NULL,
            hora_sessao TIME NOT NULL,
            PRIMARY KEY (id),
            UNIQUE KEY unique_sessao (data_sessao, hora_sessao)
        ) $charset_collate;";

        // Tabela para armazenar pacientes
        $tabela_pacientes = $wpdb->prefix . 'pacientes_agenda';
        $sql_pacientes = "CREATE TABLE $tabela_pacientes (
            id INT NOT NULL AUTO_INCREMENT,
            nome VARCHAR(100) NOT NULL,
            telefone VARCHAR(20) NOT NULL,
            PRIMARY KEY (id)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql_sessoes);
        dbDelta($sql_pacientes);
    }
}
