<?php

// Função para renderizar a lista de pacientes
function render_lista_pacientes() {
    include plugin_dir_path(__FILE__) . '../templates/lista-pacientes.php';
}

// Função para renderizar o formulário de edição de paciente
function render_editar_paciente() {
    include plugin_dir_path(__FILE__) . '../templates/editar-paciente.php';
}

// Função para cadastrar um novo paciente
function cadastrar_paciente() {
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['cadastrar_paciente'])) {
        global $wpdb;
        $tabela_pacientes = $wpdb->prefix . 'pacientes_agenda';

        $nome = sanitize_text_field($_POST['nome']);
        $telefone = sanitize_text_field($_POST['telefone']);

        // Insere o novo paciente
        $wpdb->insert($tabela_pacientes, [
            'nome' => $nome,
            'telefone' => $telefone,
        ]);

        wp_redirect(admin_url('admin.php?page=lista-pacientes&mensagem=criado'));
        exit;
    }
}
add_action('admin_post_cadastrar_paciente', 'cadastrar_paciente');

// Função para editar um paciente existente
function editar_paciente() {
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['editar_paciente'])) {
        global $wpdb;
        $tabela_pacientes = $wpdb->prefix . 'pacientes_agenda';

        $id = intval($_POST['paciente_id']);
        $nome = sanitize_text_field($_POST['nome']);
        $telefone = sanitize_text_field($_POST['telefone']);

        // Atualiza as informações do paciente
        $wpdb->update($tabela_pacientes, [
            'nome' => $nome,
            'telefone' => $telefone,
        ], ['id' => $id]);

        wp_redirect(admin_url('admin.php?page=lista-pacientes&mensagem=editado'));
        exit;
    }
}
add_action('admin_post_editar_paciente', 'editar_paciente');

// Função para excluir um paciente
function excluir_paciente() {
    if (isset($_GET['acao']) && $_GET['acao'] === 'excluir' && isset($_GET['paciente_id'])) {
        global $wpdb;
        $tabela_pacientes = $wpdb->prefix . 'pacientes_agenda';
        $paciente_id = intval($_GET['paciente_id']);

        $wpdb->delete($tabela_pacientes, ['id' => $paciente_id]);

        wp_redirect(admin_url('admin.php?page=lista-pacientes&mensagem=excluido'));
        exit;
    }
}
add_action('admin_init', 'excluir_paciente');
