<div class="wrap">
    <h2>Agendar Sessão</h2>
    
    <!-- Exibe mensagem de erro ou sucesso -->
    <?php if (isset($_GET['mensagem'])): ?>
        <div class="notice <?php echo $_GET['mensagem'] === 'sucesso' ? 'notice-success' : 'notice-error'; ?>">
            <?php if ($_GET['mensagem'] === 'sucesso'): ?>
                <p>Sessão agendada com sucesso!</p>
            <?php elseif ($_GET['mensagem'] === 'erro_horario_ocupado'): ?>
                <p>Erro: Este horário já está ocupado. Escolha outro horário.</p>
            <?php elseif ($_GET['mensagem'] === 'erro_paciente_nao_selecionado'): ?>
                <p>Erro: Selecione um paciente antes de agendar.</p>
            <?php else: ?>
                <p>Erro ao agendar a sessão. Tente novamente.</p>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
        <input type="hidden" name="action" value="agendar_sessao">

        <!-- Campo de Seleção de Paciente -->
        <label for="paciente_id">Selecione o Paciente:</label>
        <select name="paciente_id" id="paciente_id" required>
            <option value="">Selecione um paciente...</option>
            <?php
            global $wpdb;
            $pacientes = $wpdb->get_results("SELECT id, nome FROM {$wpdb->prefix}pacientes_agenda ORDER BY nome");
            foreach ($pacientes as $paciente) {
                echo '<option value="' . esc_attr($paciente->id) . '">' . esc_html($paciente->nome) . '</option>';
            }
            ?>
        </select>

        <!-- Formulário para dados da sessão -->
        <h3>Dados da Sessão</h3>

        <!-- Campo de Data da Sessão -->
        <label for="data_sessao">Data da Sessão:</label>
        <input type="date" name="data_sessao" id="data_sessao" required>

        <!-- Campo de Horário da Sessão com intervalo de 1 hora -->
        <label for="hora_sessao">Hora da Sessão:</label>
        <input type="time" name="hora_sessao" id="hora_sessao" step="3600" required>

        <!-- Campo de Local da Sessão -->
        <label for="local_sessao">Local da Sessão:</label>
        <select name="local_sessao" id="local_sessao" required>
            <option value="whatsapp">Chamada WhatsApp</option>
            <option value="google_meet">Google Meet</option>
            <option value="presencial">Presencial</option>
        </select>

      

        <button type="submit" class="button button-primary">Agendar Sessão</button>
    </form>
</div>
