<div class="wrap">
    <h2>Configurações de Folga</h2>

    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
        <input type="hidden" name="action" value="salvar_configuracoes_folga">

        <?php
        global $wpdb;
        $tabela_configuracoes = $wpdb->prefix . 'configuracoes_folga';
        $configuracoes = $wpdb->get_row("SELECT * FROM $tabela_configuracoes LIMIT 1");

        // Define valores padrão caso a configuração não exista
        $inicio_trabalho = $configuracoes->inicio_trabalho ?? '08:00';
        $fim_trabalho = $configuracoes->fim_trabalho ?? '17:00';
        $dias_folga = $configuracoes->dias_folga ?? '';
        $horarios_folga = $configuracoes->horarios_folga ?? '';

        // Garante que $dias_folga_selecionados seja um array, mesmo que esteja vazio
        $dias_folga_selecionados = !empty($dias_folga) ? explode(',', $dias_folga) : [];
        ?>

        <!-- Seleção de horário de trabalho -->
        <h3>Horário de Trabalho</h3>
        <label for="inicio_trabalho">Início do Trabalho:</label>
        <input type="time" name="inicio_trabalho" id="inicio_trabalho" required value="<?php echo esc_attr($inicio_trabalho); ?>">
        
        <label for="fim_trabalho">Fim do Trabalho:</label>
        <input type="time" name="fim_trabalho" id="fim_trabalho" required value="<?php echo esc_attr($fim_trabalho); ?>">

        <!-- Seleção de dias e horários de folga -->
        <h3>Dias e Horários de Folga</h3>
        <label for="dias_folga">Selecione os Dias de Folga:</label>
        <div>
            <?php
            $dias_semana = ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'];
            foreach ($dias_semana as $indice => $dia) {
                $checked = in_array($indice, $dias_folga_selecionados) ? 'checked' : '';
                echo "<label><input type='checkbox' name='dias_folga[]' value='$indice' $checked> $dia</label><br>";
            }
            ?>
        </div>

        <h4>Horários de Folga Específicos</h4>
        <label for="horarios_folga">Horários de Folga:</label>
        <input type="text" name="horarios_folga" id="horarios_folga" placeholder="Ex.: 09:00, 11:00" value="<?php echo esc_attr($horarios_folga); ?>">

        <button type="submit" class="button button-primary">Salvar Configurações</button>
    </form>
</div>
