<div class="wrap">
    <h2>Dias de Folga</h2>

    <!-- Formulário para adicionar um novo dia de folga -->
    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
        <input type="hidden" name="action" value="salvar_dia_de_folga">
        
        <label for="data_folga">Selecione o Dia de Folga:</label>
        <input type="date" name="data_folga" id="data_folga" required>
        
        <button type="submit" class="button button-primary">Adicionar Dia de Folga</button>
    </form>

    <hr>

    <!-- Lista dos dias de folga salvos -->
    <h3>Dias de Folga Cadastrados</h3>
    <table class="widefat fixed" cellspacing="0">
        <thead>
            <tr>
                <th>Data</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php
            global $wpdb;
            $tabela_dias_folga = $wpdb->prefix . 'dias_folga';
            $dias_folga = $wpdb->get_results("SELECT * FROM $tabela_dias_folga ORDER BY data_folga");

            if ($dias_folga) :
                foreach ($dias_folga as $folga) : ?>
                    <tr>
                        <td><?php echo esc_html($folga->data_folga); ?></td>
                        <td>
                            <a href="<?php echo admin_url('admin-post.php?action=excluir_dia_de_folga&dia_id=' . $folga->id); ?>" 
                               class="button button-secondary"
                               onclick="return confirm('Tem certeza que deseja excluir este dia de folga?');">Excluir</a>
                        </td>
                    </tr>
                <?php endforeach;
            else : ?>
                <tr><td colspan="2">Nenhum dia de folga cadastrado.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
