<div class="wrap">
    <h2>Lista de Pacientes</h2>

    <?php if (isset($_GET['mensagem'])): ?>
        <div class="notice notice-success">
            <p>
                <?php
                switch ($_GET['mensagem']) {
                    case 'criado':
                        echo 'Paciente criado com sucesso!';
                        break;
                    case 'editado':
                        echo 'Paciente editado com sucesso!';
                        break;
                    case 'excluido':
                        echo 'Paciente excluído com sucesso!';
                        break;
                }
                ?>
            </p>
        </div>
    <?php endif; ?>

    <!-- Formulário para cadastrar um novo paciente -->
    <h3>Cadastrar Novo Paciente</h3>
    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
        <input type="hidden" name="action" value="cadastrar_paciente">
        
        <label for="nome">Nome:</label>
        <input type="text" name="nome" id="nome" required>
        
        <label for="telefone">Telefone (WhatsApp):</label>
        <input type="text" name="telefone" id="telefone" required>
        
        <button type="submit" name="cadastrar_paciente" class="button button-primary">Cadastrar</button>
    </form>

    <hr>

    <!-- Lista de pacientes com opções de editar e excluir -->
    <table class="widefat fixed" cellspacing="0">
        <thead>
            <tr>
                <th>Nome</th>
                <th>Telefone (WhatsApp)</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php
            global $wpdb;
            $tabela_pacientes = $wpdb->prefix . 'pacientes_agenda';
            $pacientes = $wpdb->get_results("SELECT * FROM $tabela_pacientes ORDER BY nome");

            if ($pacientes):
                foreach ($pacientes as $paciente): ?>
                    <tr>
                        <td><?php echo esc_html($paciente->nome); ?></td>
                        <td><?php echo esc_html($paciente->telefone); ?></td>
                        <td>
                            <a href="<?php echo admin_url('admin.php?page=editar-paciente&paciente_id=' . $paciente->id); ?>" class="button">Editar</a>
                            <a href="<?php echo admin_url('admin.php?page=lista-pacientes&acao=excluir&paciente_id=' . $paciente->id); ?>" class="button button-secondary" onclick="return confirm('Tem certeza que deseja excluir este paciente?');">Excluir</a>
                        </td>
                    </tr>
                <?php endforeach;
            else: ?>
                <tr><td colspan="3">Nenhum paciente cadastrado.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
