<div class="wrap">
    <h2>Lista de Sessões</h2>

    <!-- Botões de Filtro -->
    <div class="filtro-sessoes">
        <a href="<?php echo admin_url('admin.php?page=lista-sessoes'); ?>" class="button-filtro <?php echo empty($_GET['filtro']) ? 'active' : ''; ?>">
            <i class="fas fa-calendar-alt"></i> Todas as Sessões
        </a>
        <a href="<?php echo admin_url('admin.php?page=lista-sessoes&filtro=hoje'); ?>" class="button-filtro <?php echo isset($_GET['filtro']) && $_GET['filtro'] === 'hoje' ? 'active' : ''; ?>">
            <i class="fas fa-calendar-day"></i> Sessões de Hoje
        </a>
        <a href="<?php echo admin_url('admin.php?page=lista-sessoes&filtro=futuras'); ?>" class="button-filtro <?php echo isset($_GET['filtro']) && $_GET['filtro'] === 'futuras' ? 'active' : ''; ?>">
            <i class="fas fa-calendar-plus"></i> Sessões Futuras
        </a>
    </div>

    <?php
    global $wpdb;
    $tabela_sessoes = $wpdb->prefix . 'sessoes_agenda';
    $filtro = isset($_GET['filtro']) ? sanitize_text_field($_GET['filtro']) : '';
    $hoje = date('Y-m-d');

    // Define a consulta SQL com base no filtro selecionado
    if ($filtro === 'hoje') {
        $sessoes = $wpdb->get_results($wpdb->prepare("SELECT * FROM $tabela_sessoes WHERE data_sessao = %s ORDER BY data_sessao, hora_sessao", $hoje));
    } elseif ($filtro === 'futuras') {
        $sessoes = $wpdb->get_results($wpdb->prepare("SELECT * FROM $tabela_sessoes WHERE data_sessao > %s ORDER BY data_sessao, hora_sessao", $hoje));
    } else {
        $sessoes = $wpdb->get_results("SELECT * FROM $tabela_sessoes ORDER BY data_sessao, hora_sessao");
    }
    ?>

    <!-- Tabela de Sessões -->
    <table class="widefat fixed" cellspacing="0">
        <thead>
            <tr>
                <th>Nome do Paciente</th>
                <th>Telefone</th>
                <th>Local da Sessão</th>
                <th>Data</th>
                <th>Horário</th>
                <th>Status</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($sessoes) : ?>
                <?php foreach ($sessoes as $sessao) : ?>
                    <tr>
                        <td><?php echo esc_html($sessao->nome_paciente); ?></td>
                        <td><?php echo esc_html($sessao->telefone); ?></td>
                        <td><?php echo esc_html(ucwords(str_replace('_', ' ', $sessao->local_sessao))); ?></td>
                        <td><?php echo esc_html($sessao->data_sessao); ?></td>
                        <td><?php echo esc_html($sessao->hora_sessao); ?></td>
                        <td><?php echo esc_html($sessao->status === 'cancelada' ? 'Cancelada' : 'Ativa'); ?></td>
                        <td>
                            <?php if ($sessao->status === 'ativa') : ?>
                                <a href="<?php echo admin_url('admin.php?page=lista-sessoes&acao=cancelar&sessao_id=' . $sessao->id); ?>" class="button button-secondary" onclick="return confirm('Tem certeza que deseja cancelar esta sessão?');">Cancelar</a>
                            <?php else : ?>
                                <a href="<?php echo admin_url('admin-post.php?action=excluir_sessao_cancelada&sessao_id=' . $sessao->id); ?>" class="button button-secondary" onclick="return confirm('Tem certeza que deseja excluir esta sessão cancelada?');">Excluir</a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else : ?>
                <tr><td colspan="7">Nenhuma sessão encontrada.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- Tabela de Sessões Canceladas -->
    <h3>Sessões Canceladas</h3>
    <table class="widefat fixed" cellspacing="0">
        <thead>
            <tr>
                <th>Nome do Paciente</th>
                <th>Telefone</th>
                <th>Local da Sessão</th>
                <th>Data</th>
                <th>Horário</th>
                <th>Status</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sessoes_canceladas = $wpdb->get_results("SELECT * FROM $tabela_sessoes WHERE status = 'cancelada' ORDER BY data_sessao, hora_sessao");

            if ($sessoes_canceladas) :
                foreach ($sessoes_canceladas as $sessao) : ?>
                    <tr>
                        <td><?php echo esc_html($sessao->nome_paciente); ?></td>
                        <td><?php echo esc_html($sessao->telefone); ?></td>
                        <td><?php echo esc_html(ucwords(str_replace('_', ' ', $sessao->local_sessao))); ?></td>
                        <td><?php echo esc_html($sessao->data_sessao); ?></td>
                        <td><?php echo esc_html($sessao->hora_sessao); ?></td>
                        <td><?php echo esc_html('Cancelada'); ?></td>
                        <td>
                            <a href="<?php echo admin_url('admin-post.php?action=excluir_sessao_cancelada&sessao_id=' . $sessao->id); ?>" 
                               class="button button-secondary"
                               onclick="return confirm('Tem certeza que deseja excluir esta sessão cancelada?');">Excluir</a>
                        </td>
                    </tr>
                <?php endforeach;
            else : ?>
                <tr><td colspan="7">Nenhuma sessão cancelada encontrada.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
